<?php
include 'conexao.php';

$curso = $_GET['curso'] ?? '';
$turma = $_GET['turma'] ?? '';

$stmt = $conn->prepare("SELECT nome, idade, genero FROM novos_alunos WHERE curso = ? AND turma = ? AND obs = 'Admitido' ORDER BY nome ASC");
$stmt->bind_param("ss", $curso, $turma);
$stmt->execute();
$alunos = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>
<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Lista de Admitidos - <?= htmlspecialchars($turma) ?></title>
  <style>
    body {
      font-family: Arial, sans-serif;
      padding: 20px;
    }
    h2 {
      text-align: center;
      margin-bottom: 10px;
    }
    h4 {
      text-align: center;
      margin-bottom: 20px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      border: 1px solid #333;
      padding: 8px;
      text-align: center;
    }
    th {
      background: #444;
      color: white;
    }
    td.nome {
      text-align: left;
    }
    @media print {
      button {
        display: none;
      }
    }
  </style>
</head>
<body>

<h2>Lista de Alunos Admitidos</h2>
<h4>Curso: <?= htmlspecialchars($curso) ?> | Turma: <?= htmlspecialchars($turma) ?></h4>

<table>
  <tr>
    <th>Nº</th>
    <th>Nome</th>
    <th>Idade</th>
    <th>Género</th>
  </tr>
  <?php
  $n = 1;
  foreach ($alunos as $al) {
      echo "<tr>
              <td>$n</td>
              <td class='nome'>" . htmlspecialchars($al['nome']) . "</td>
              <td>{$al['idade']}</td>
              <td>{$al['genero']}</td>
            </tr>";
      $n++;
  }
  ?>
</table>

echo "</table>";

// Botão imprimir
echo "<form action='imprimir_lista_admitidos.php' method='GET' target='_blank' style='margin-top:10px;'>
        <input type='hidden' name='curso' value='" . htmlspecialchars($curso) . "'>
        <input type='hidden' name='turma' value='" . htmlspecialchars($turma) . "'>
        <button type='submit' style='background:#28a745; color:white; padding:8px 16px; border:none; border-radius:4px; cursor:pointer;'>
            🖨️ Imprimir Lista
        </button>
      </form><hr>";








<br>
<button onclick="window.print()">🖨️ Imprimir Agora</button>

</body>
</html>
